const menuIcon = document.querySelector('#menu-icon');
const navbar = document.querySelector('.navbar');

menuIcon.onclick = () => {
    menuIcon.classList.toggle('bx-x');
    navbar.classList.toggle('active')
}

document.addEventListener("DOMContentLoaded", () => {
  // ---------- Menu toggle ----------
  const menuIcon = document.querySelector("#menu-icon");
  const navbar = document.querySelector(".navbar");

  if (menuIcon && navbar) {
    menuIcon.addEventListener("click", () => {
      menuIcon.classList.toggle("bx-x");
      navbar.classList.toggle("active");
    });
  }

  // ---------- Contact form (Formspree) ----------
  const contactForm = document.querySelector("#contactForm");

  // Helper: create a small status message element under the form
  function showStatusMessage(text, isError = false) {
    let el = document.querySelector("#contact-status");
    if (!el) {
      el = document.createElement("div");
      el.id = "contact-status";
      el.style.marginTop = "1rem";
      el.style.padding = "0.9rem 1rem";
      el.style.borderRadius = "0.6rem";
      el.style.fontSize = "1.4rem";
      el.style.textAlign = "center";
      const formParent = contactForm ? contactForm.parentElement : document.body;
      formParent.appendChild(el);
    }
    el.textContent = text;
    el.style.color = isError ? "#b11212" : "#0b7a16";
    el.style.backgroundColor = isError ? "rgba(177,18,18,0.08)" : "rgba(11,122,22,0.06)";

    // remove after 6 seconds
    clearTimeout(showStatusMessage._timeout);
    showStatusMessage._timeout = setTimeout(() => {
      if (el) el.remove();
    }, 6000);
  }

  if (contactForm) {
    contactForm.addEventListener("submit", async (e) => {
      e.preventDefault();

      // ensure the form has an action
      const endpoint = (contactForm.action || "").trim();
      if (!endpoint) {
        showStatusMessage("Form endpoint not configured. Add your Formspree action URL.", true);
        return;
      }

      // collect form data
      const formData = new FormData(contactForm);

      try {
        const res = await fetch(endpoint, {
          method: contactForm.method || "POST",
          body: formData,
          headers: {
            Accept: "application/json",
          },
        });

        // success if ok
        if (res.ok) {
          showStatusMessage("✅ Message sent! I will get back to you soon.");
          contactForm.reset();
        } else {
          // try to read error message from response JSON
          let msg = "❌ Failed to send message. Please try again later.";
          try {
            const data = await res.json();
            if (data) {
              if (data.error) msg = `❌ ${data.error}`;
              else if (data.errors && Array.isArray(data.errors)) {
                msg = `❌ ${data.errors.map((x) => x.message || x).join(", ")}`;
              } else if (data.message) {
                msg = `❌ ${data.message}`;
              }
            }
          } catch (parseErr) {
            // ignore JSON parse errors and keep default msg
            console.warn("Could not parse error JSON:", parseErr);
          }
          showStatusMessage(msg, true);
        }
      } catch (err) {
        console.error("Contact form error:", err);
        showStatusMessage("❌ Network error. Check your connection and try again.", true);
      }
    });
  } else {
    console.warn("No #contactForm found in the document. Contact form script skipped.");
  }
});
